#--------------------------------------------------------
#	Script PiXYZ STUDIO - Run Generic Process
#
#	This Python script is meant to be used in PiXYZ STUDIO 
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#	
#	This script is an APPROXIMATE version in Python of the scenario RUN GENERIC PROCESS available in the SCENARIOS menu
#	See the API documentation for more information on that specific scenario, and on all the unitary algorithms used below
#	
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

OVERRIDE_EXISTING_UVs=False
REPACK_UVs=False
MAP_SIZE=1024
MAP_PADDING_REPACK=1

#Deletes hidden parts (visibility off)
scene.selectPartsFromNoShow()
scene.deleteOccurrences(scene.getSelectionedOccurrences())

#Merges parts located in final assemblies in the Product Structure (tree)
scene.mergeFinalAssemblies()

#Compresses the tree
scene.compress

#Gets scene root node
root = [[scene.getRoot()]]

#If mesh models are present in the scene (by opposition to CAD models), UVs are created by projection on channel 1, if required (OVERRIDE_EXISTING_UVs=True)
algo.mapUvOnCubicAABB(root, 100, 1, OVERRIDE_EXISTING_UVs)

#Repairs CAD models if present in the scene (does nothing otherwise)
algo.repairCAD(root, 0.1, False)

#Creates meshes out of CAD models if present in the scene (does nothing otherwise), with automatic UV generation (based on CAD faces) on channel 1
algo.tessellate(root, 0.15, -1, -1, True, algo.UVGenerationMode.UniformUV, 1)

#Repairs meshes
algo.repairMesh(root, 0.1)

#Deletes patches on the meshes prior to decimate them
algo.deletePatches(root)

#Deletes lines, useless for export
algo.deleteLines(root)

#Decimates meshes to optimize polygon count
algo.decimate(root, 1, -1, 1)

#Creates UVs by projection on channel 0 for the meshes created out of CAD model, if required (OVERRIDE_EXISTING_UVs=True)
algo.mapUvOnCubicAABB(root, 100, 0, OVERRIDE_EXISTING_UVs)

if REPACK_UVs:
    algo.repackUV(root, 1, True, MAP_SIZE, MAP_PADDING_REPACK, True, 3)
